# QUICK START GUIDE
## How to Create Your Wealth Strategy Plan with AI

**A RealWealth Resource | Created by Rich Fettke**

---

## WHAT YOU'VE RECEIVED

You have four documents:

1. **Wealth Strategy Coach Prompt (Generic Version)** — Works with ChatGPT, Gemini, and other AI tools
2. **Wealth Strategy Coach Prompt (Claude Version)** — Optimized for Claude with Project setup instructions
3. **Financial Security Guidelines** — How to protect your privacy while using AI (for you to read)
4. **Financial Security Monitor (AI Instructions)** — Upload this to your AI project so it watches out for you and alerts you if you accidentally share sensitive information

---

## CHOOSE YOUR PATH

### Option A: Using Claude (Recommended)

Claude's "Projects" feature lets you save your Wealth Strategy Plan so the AI remembers your complete financial picture in every future conversation. This is ideal for ongoing financial coaching.

**Why Claude is recommended for financial planning:**

- **Stronger default privacy:** Claude does NOT use your conversations for AI training by default. Your data stays private without having to find and change settings. ChatGPT and Gemini use your data for training unless you opt out.
- **Clearer privacy policy:** Independent reviewers consistently rate Anthropic's (Claude's) privacy policy as the clearest and most transparent of the major AI platforms.
- **Security certifications:** Claude is backed by SOC 2 Type II and ISO 42001 security certifications.
- **Limited data collection:** Claude's data collection is limited to your activity within the service itself—it doesn't pull from your broader web browsing or other apps.

**You'll need:** A Claude Pro subscription ($20/month at claude.ai)

**Use this document:** Wealth Strategy Coach Prompt (Claude Version)

---

### Option B: Using ChatGPT, Gemini, or Other AI Tools

You can create your Wealth Strategy Plan in ChatGPT, Gemini, or other AI tools. These platforms also have features to help the AI remember your plan:

- **ChatGPT** has Memory and Custom Instructions—you can ask ChatGPT to remember your plan or paste key details into your Custom Instructions (Settings → Personalization → Custom Instructions)
- **Gemini** has Gems—you can create a custom "Wealth Strategy Coach" Gem with your plan details and even upload your completed plan as a reference file (requires Gemini Advanced)

**You'll need:** Access to ChatGPT, Gemini, or another AI assistant (free versions work, but paid versions offer better memory features)

**Use this document:** Wealth Strategy Coach Prompt (Generic Version)

---

## STEP-BY-STEP INSTRUCTIONS

### Step 1: Read the Security Guidelines (5 minutes)

Before you start, read the **Financial Security Guidelines** document. It shows you how to:
- Use nicknames instead of real addresses and legal entity names
- Round your numbers for privacy
- Keep sensitive information (account numbers, SSNs, passwords) off the AI platform

**Key takeaway:** AI doesn't need your exact details to help you plan. Rounded numbers and nicknames work just as well.

---

### Step 2: Prepare Your Information (15-30 minutes)

Gather the following before you start (approximate numbers are fine):

- [ ] Your age and family situation
- [ ] Your financial goals (target net worth, passive income, retirement age)
- [ ] Your income sources and approximate amounts
- [ ] Your monthly expenses (rough categories)
- [ ] Your assets (properties, retirement accounts, investments, savings)
- [ ] Your debts (balances, interest rates, monthly payments)
- [ ] Your professional team (CPA, attorney, bookkeeper, etc.)

**If you have a more complex situation**, also gather:
- [ ] Your entity structure (LLCs, S-Corps, trusts)
- [ ] Details on each property you own
- [ ] Information on businesses or alternative investments

---

### Step 3: Start the Conversation (30-60 minutes)

**For Claude users:**
1. Go to claude.ai and log in
2. Click "Projects" in the left sidebar
3. Click "Create Project" and name it (e.g., "My Wealth Strategy")
4. Start a new conversation inside your Project
5. Copy everything below the dotted line in the Claude Version document
6. Paste it into the chat and press Enter
7. Answer the questions as your Wealth Strategy Coach guides you through

**For ChatGPT/Gemini users:**
1. Open your AI tool of choice
2. Copy everything below the dotted line in the Generic Version document
3. Paste it into the chat and press Enter
4. Answer the questions as your Wealth Strategy Coach guides you through

**Pro Tip:** You don't have to type! Use voice-to-text (click the microphone icon in Claude or ChatGPT) or dictation software like Wispr Flow to speak your answers naturally.

---

### Step 4: Save Your Completed Plan (5 minutes)

When the AI finishes compiling your Wealth Strategy Plan:

**Claude users:**
1. Copy the entire completed plan and save it as a document on your computer (Word, Google Doc, or text file)
2. In your Project, click "Add Content" or the "+" icon
3. Upload your saved Wealth Strategy Plan document to your Project Files
4. Also upload the **Financial Security Monitor (AI Instructions)** document. This tells Claude to watch for sensitive information and alert you if you accidentally share something you shouldn't.
5. Now Claude will remember your financial situation AND watch your back for security in every future conversation!

**ChatGPT users:**
1. Copy the entire completed plan
2. Save it in a document on your computer for reference
3. To help ChatGPT remember: Go to Settings → Personalization → Custom Instructions
4. Paste a summary of your key financial details (goals, net worth, income, main assets) into "What would you like ChatGPT to know about you?"
5. **Add Security Monitoring:** In the "How would you like ChatGPT to respond?" section, add a note like: "When I share financial information, watch for sensitive data like account numbers, SSNs, exact addresses, or very precise figures. Alert me if I accidentally share something I shouldn't, and suggest safer alternatives like nicknames and rounded numbers."
6. You can also say "Please remember my Wealth Strategy Plan" and paste the key details—ChatGPT's Memory feature will retain them for future conversations

**Gemini users (with Gemini Advanced):**
1. Copy the entire completed plan and save it to a document on your computer
2. Go to gemini.google.com → Click "Explore Gems" → Click "New Gem"
3. Name it "My Wealth Strategy Coach" 
4. In the instructions, paste your Wealth Strategy Plan or a detailed summary
5. **Add Security Monitoring:** Also paste key points from the **Financial Security Monitor** document into your Gem instructions, or upload it as a reference file. This tells Gemini to alert you if you share sensitive information.
6. Click "Add files" to upload your saved plan document for reference
7. Click Save—now you have a custom Wealth Strategy Coach Gem that knows your complete financial picture and watches out for your privacy!

**Other AI tools:**
1. Copy the entire completed plan
2. Save it in a document on your computer (Word, Google Doc, or Notes app)
3. When you want AI help in the future, paste your plan at the start of a new conversation

---

### Step 5: Use Your Wealth Strategy Coach (Ongoing)

Your Wealth Strategy Plan isn't a one-time document—it's a living tool. Here's how to use it:

**Monthly (15 minutes):**
Start a conversation and say something like:
> "Let's do a quick monthly check-in. My income this month was about $X and expenses were about $Y. How's my cash flow looking?"

**Quarterly (30-45 minutes):**
Start a conversation and say:
> "Time for a quarterly review. Here are my updated numbers: [share updates]. What's my current net worth and how am I tracking toward my goals?"

**When making decisions:**
Ask the AI to help you think through scenarios:
> "I'm considering buying a rental property for ~$300K with 25% down. How would this affect my portfolio?"
> "What if I paid off my HELOC this month? How would that change my cash flow?"

**When things change:**
Update your plan when you buy or sell property, pay off debt, change jobs, or have other significant changes:
> "I need to update my Wealth Strategy Plan. I just sold [Property X] for ~$Y. Please help me generate an updated version."

---

## TIPS FOR SUCCESS

1. **Start with what you know.** It's okay to say "I'm not sure" or "TBD" for things you need to research later.

2. **Round everything.** ~$500K is just as useful as $498,247 for planning purposes—and much safer.

3. **Use nicknames consistently.** Pick a nickname for each property and entity and stick with it.

4. **Review quarterly.** Set a calendar reminder to update your plan every 3 months.

5. **Keep a private reference sheet.** Map your nicknames to real information in a secure document on your own computer.

---

## NEED HELP?

If you get stuck or have questions about using AI for financial planning, RealWealth is here to help.

RealWealth simplifies real estate investing. Whether you're looking to acquire single-family or 2-4 unit turnkey rental properties, or invest passively in real estate syndications and funds, we're your resource for building wealth through real estate.

**Learn more at RealWealth.com**

---

## YOU'RE READY!

You now have everything you need to create your own Wealth Strategy Plan. This is the same approach Rich and Kathy Fettke use to manage their own multi-property portfolio and plan for their financial future.

Take the first step today. Open Claude or ChatGPT, paste the prompt, and start building your roadmap to wealth.

**Your future self will thank you.**
